/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DeleteOnExitHook;
import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import jdk.internal.util.StaticProperty;

public class File
implements Serializable,
Comparable<File> {
    private static FileSystem fs = FileSystem.getFileSystem();
    private String path;
    private transient int prefixLength;
    public static final char separatorChar = fs.getSeparator();
    public static final String separator = "" + separatorChar;
    public static final char pathSeparatorChar = fs.getPathSeparator();
    public static final String pathSeparator = "" + pathSeparatorChar;
    private static final long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String string, int n) {
        this.path = string;
        this.prefixLength = n;
    }

    private File(String string, File file) {
        assert (file.path != null);
        assert (!file.path.equals(""));
        this.path = fs.resolve(file.path, string);
        this.prefixLength = file.prefixLength;
    }

    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string != null ? (string.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string2)) : fs.resolve(fs.normalize(string), fs.normalize(string2))) : fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(File file, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = file != null ? (file.path.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string)) : fs.resolve(file.path, fs.normalize(string))) : fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String string2 = uRI.getPath();
        if (string2.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        string2 = fs.fromURIPath(string2);
        if (separatorChar != '/') {
            string2 = string2.replace('/', separatorChar);
        }
        this.path = fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < this.prefixLength) {
            return this.path.substring(this.prefixLength);
        }
        return this.path.substring(n + 1);
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < this.prefixLength) {
            if (this.prefixLength > 0 && this.path.length() > this.prefixLength) {
                return this.path.substring(0, this.prefixLength);
            }
            return null;
        }
        return this.path.substring(0, n);
    }

    public File getParentFile() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new File(string, this.prefixLength);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return fs.isAbsolute(this);
    }

    public String getAbsolutePath() {
        return fs.resolve(this);
    }

    public File getAbsoluteFile() {
        String string = this.getAbsolutePath();
        return new File(string, fs.prefixLength(string));
    }

    public String getCanonicalPath() throws IOException {
        return fs.canonicalize(fs.resolve(this));
    }

    public File getCanonicalFile() throws IOException {
        String string = this.getCanonicalPath();
        return new File(string, fs.prefixLength(string));
    }

    private static String slashify(String string, boolean bl) {
        String string2 = string;
        if (separatorChar != '/') {
            string2 = string2.replace(separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl) {
            string2 = string2 + "/";
        }
        return string2;
    }

    @Deprecated
    public URL toURL() throws MalformedURLException {
        return new URL("file", "", File.slashify(this.getAbsolutePath(), this.isDirectory()));
    }

    public URI toURI() {
        try {
            File file = this.getAbsoluteFile();
            String string = File.slashify(file.getPath(), file.isDirectory());
            if (string.startsWith("//")) {
                string = "//" + string;
            }
            return new URI("file", null, string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
    }

    public boolean canRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.checkAccess(this, 4);
    }

    public boolean canWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.checkAccess(this, 2);
    }

    public boolean exists() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 1) != 0;
    }

    public boolean isDirectory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 4) != 0;
    }

    public boolean isFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 2) != 0;
    }

    public boolean isHidden() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 8) != 0;
    }

    public long lastModified() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.getLastModifiedTime(this);
    }

    public long length() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.getLength(this);
    }

    public boolean createNewFile() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.createFileExclusively(this.path);
    }

    public boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        return fs.delete(this);
    }

    public void deleteOnExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        DeleteOnExitHook.add(this.path);
    }

    public String[] list() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.list(this);
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null || filenameFilter == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!filenameFilter.accept(this, stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public File[] listFiles() {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(stringArray[i], this);
        }
        return fileArray;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            if (filenameFilter != null && !filenameFilter.accept(this, string)) continue;
            arrayList.add(new File(string, this));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public File[] listFiles(FileFilter fileFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            File file = new File(string, this);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public boolean mkdir() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.createDirectory(this);
    }

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        File file = null;
        try {
            file = this.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        File file2 = file.getParentFile();
        return file2 != null && (file2.mkdirs() || file2.exists()) && file.mkdir();
    }

    public boolean renameTo(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
            securityManager.checkWrite(file.path);
        }
        return fs.rename(this, file);
    }

    public boolean setLastModified(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setLastModifiedTime(this, l);
    }

    public boolean setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setReadOnly(this);
    }

    public boolean setWritable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setPermission(this, 2, bl, bl2);
    }

    public boolean setWritable(boolean bl) {
        return this.setWritable(bl, true);
    }

    public boolean setReadable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setPermission(this, 4, bl, bl2);
    }

    public boolean setReadable(boolean bl) {
        return this.setReadable(bl, true);
    }

    public boolean setExecutable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setPermission(this, 1, bl, bl2);
    }

    public boolean setExecutable(boolean bl) {
        return this.setExecutable(bl, true);
    }

    public boolean canExecute() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(this.path);
        }
        return fs.checkAccess(this, 1);
    }

    public static File[] listRoots() {
        return fs.listRoots();
    }

    public long getTotalSpace() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        return fs.getSpace(this, 0);
    }

    public long getFreeSpace() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        return fs.getSpace(this, 1);
    }

    public long getUsableSpace() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        return fs.getSpace(this, 2);
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2;
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        File file3 = file != null ? file : TempDirectory.location();
        SecurityManager securityManager = System.getSecurityManager();
        do {
            file2 = TempDirectory.generateFile(string, string2, file3);
            if (securityManager == null) continue;
            try {
                securityManager.checkWrite(file2.getPath());
            }
            catch (SecurityException securityException) {
                if (file == null) {
                    throw new SecurityException("Unable to create temporary file");
                }
                throw securityException;
            }
        } while (!fs.createFileExclusively(file2.getPath()));
        return file2;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    @Override
    public int compareTo(File file) {
        return fs.compare(this, file);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof File) {
            return this.compareTo((File)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return fs.hashCode(this);
    }

    public String toString() {
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("path", null);
        char c = objectInputStream.readChar();
        if (c != separatorChar) {
            string = string.replace(c, separatorChar);
        }
        this.path = fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path toPath() {
        Path path = this.filePath;
        if (path == null) {
            File file = this;
            synchronized (file) {
                path = this.filePath;
                if (path == null) {
                    this.filePath = path = FileSystems.getDefault().getPath(this.path, new String[0]);
                }
            }
        }
        return path;
    }

    static /* synthetic */ FileSystem access$000() {
        return fs;
    }

    private static class TempDirectory {
        private static final File TMPDIR = new File(StaticProperty.javaIoTmpDir());
        private static final SecureRandom RANDOM = new SecureRandom();

        private TempDirectory() {
        }

        static File location() {
            return TMPDIR;
        }

        private static int shortenSubName(int subNameLength, int excess, int nameMin) {
            int newLength = Math.max(nameMin, subNameLength - excess);
            if (newLength < subNameLength) {
                return newLength;
            }
            return subNameLength;
        }

        static File generateFile(String prefix, String suffix, File dir) throws IOException {
            String name;
            int nameMax;
            int suffixLength;
            int nusLength;
            long n = RANDOM.nextLong();
            String nus = Long.toUnsignedString((long)n);
            int prefixLength = (prefix = new File(prefix).getName()).length();
            int excess = prefixLength + (nusLength = nus.length()) + (suffixLength = suffix.length()) - (nameMax = FS.getNameMax(dir.getPath()));
            if (excess <= 0) {
                name = prefix + nus + suffix;
            } else {
                if ((excess = (prefixLength = TempDirectory.shortenSubName(prefixLength, excess, 3)) + nusLength + suffixLength - nameMax) > 0) {
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, suffix.indexOf(".") == 0 ? 4 : 0);
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, 3);
                    excess = prefixLength + nusLength + suffixLength - nameMax;
                }
                if (excess > 0 && excess <= nusLength - 5) {
                    nusLength = TempDirectory.shortenSubName(nusLength, excess, 5);
                }
                StringBuilder sb = new StringBuilder(prefixLength + nusLength + suffixLength);
                sb.append(prefixLength < prefix.length() ? prefix.substring(0, prefixLength) : prefix);
                sb.append(nusLength < nus.length() ? nus.substring(0, nusLength) : nus);
                sb.append(suffixLength < suffix.length() ? suffix.substring(0, suffixLength) : suffix);
                name = sb.toString();
            }
            name = FS.normalize(name);
            File f = new File(dir, name);
            if (!name.equals(f.getName()) || f.isInvalid()) {
                if (System.getSecurityManager() != null) {
                    throw new IOException("Unable to create temporary file");
                }
                throw new IOException("Unable to create temporary file, " + name);
            }
            return f;
        }
    }
}

