/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadLocal<T> {
    private final int threadLocalHashCode = ThreadLocal.nextHashCode();
    private static AtomicInteger nextHashCode = new AtomicInteger();
    private static final int HASH_INCREMENT = 1640531527;

    private static int nextHashCode() {
        return nextHashCode.getAndAdd(1640531527);
    }

    protected T initialValue() {
        return null;
    }

    public T get() {
        ThreadLocalMap.Entry entry;
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null && (entry = threadLocalMap.getEntry(this)) != null) {
            return (T)entry.value;
        }
        return this.setInitialValue();
    }

    private T setInitialValue() {
        T t = this.initialValue();
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            threadLocalMap.set(this, t);
        } else {
            this.createMap(thread, t);
        }
        return t;
    }

    public void set(T t) {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            threadLocalMap.set(this, t);
        } else {
            this.createMap(thread, t);
        }
    }

    public void remove() {
        ThreadLocalMap threadLocalMap = this.getMap(Thread.currentThread());
        if (threadLocalMap != null) {
            threadLocalMap.remove(this);
        }
    }

    ThreadLocalMap getMap(Thread thread) {
        return thread.threadLocals;
    }

    void createMap(Thread thread, T t) {
        thread.threadLocals = new ThreadLocalMap(this, t);
    }

    static ThreadLocalMap createInheritedMap(ThreadLocalMap threadLocalMap) {
        return new ThreadLocalMap(threadLocalMap);
    }

    T childValue(T t) {
        throw new UnsupportedOperationException();
    }

    static class ThreadLocalMap {
        private static final int INITIAL_CAPACITY = 16;
        private Entry[] table;
        private int size = 0;
        private int threshold;

        private void setThreshold(int n) {
            this.threshold = n * 2 / 3;
        }

        private static int nextIndex(int n, int n2) {
            return n + 1 < n2 ? n + 1 : 0;
        }

        private static int prevIndex(int n, int n2) {
            return n - 1 >= 0 ? n - 1 : n2 - 1;
        }

        ThreadLocalMap(ThreadLocal threadLocal, Object object) {
            this.table = new Entry[16];
            int n = threadLocal.threadLocalHashCode & 0xF;
            this.table[n] = new Entry(threadLocal, object);
            this.size = 1;
            this.setThreshold(16);
        }

        private ThreadLocalMap(ThreadLocalMap threadLocalMap) {
            Entry[] entryArray = threadLocalMap.table;
            int n = entryArray.length;
            this.setThreshold(n);
            this.table = new Entry[n];
            for (int i = 0; i < n; ++i) {
                ThreadLocal threadLocal;
                Entry entry = entryArray[i];
                if (entry == null || (threadLocal = (ThreadLocal)entry.get()) == null) continue;
                Object object = threadLocal.childValue(entry.value);
                Entry entry2 = new Entry(threadLocal, object);
                int n2 = threadLocal.threadLocalHashCode & n - 1;
                while (this.table[n2] != null) {
                    n2 = ThreadLocalMap.nextIndex(n2, n);
                }
                this.table[n2] = entry2;
                ++this.size;
            }
        }

        private Entry getEntry(ThreadLocal threadLocal) {
            int n = threadLocal.threadLocalHashCode & this.table.length - 1;
            Entry entry = this.table[n];
            if (entry != null && entry.get() == threadLocal) {
                return entry;
            }
            return this.getEntryAfterMiss(threadLocal, n, entry);
        }

        private Entry getEntryAfterMiss(ThreadLocal threadLocal, int n, Entry entry) {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            while (entry != null) {
                ThreadLocal threadLocal2 = (ThreadLocal)entry.get();
                if (threadLocal2 == threadLocal) {
                    return entry;
                }
                if (threadLocal2 == null) {
                    this.expungeStaleEntry(n);
                } else {
                    n = ThreadLocalMap.nextIndex(n, n2);
                }
                entry = entryArray[n];
            }
            return null;
        }

        private void set(ThreadLocal threadLocal, Object object) {
            int n;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = threadLocal.threadLocalHashCode & n2 - 1;
            Entry entry = entryArray[n3];
            while (entry != null) {
                ThreadLocal threadLocal2 = (ThreadLocal)entry.get();
                if (threadLocal2 == threadLocal) {
                    entry.value = object;
                    return;
                }
                if (threadLocal2 == null) {
                    this.replaceStaleEntry(threadLocal, object, n3);
                    return;
                }
                n3 = ThreadLocalMap.nextIndex(n3, n2);
                entry = entryArray[n3];
            }
            entryArray[n3] = new Entry(threadLocal, object);
            if (!this.cleanSomeSlots(n3, n = ++this.size) && n >= this.threshold) {
                this.rehash();
            }
        }

        private void remove(ThreadLocal threadLocal) {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = threadLocal.threadLocalHashCode & n - 1;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.get() == threadLocal) {
                    entry.clear();
                    this.expungeStaleEntry(n2);
                    return;
                }
                n2 = ThreadLocalMap.nextIndex(n2, n);
                entry = entryArray[n2];
            }
        }

        private void replaceStaleEntry(ThreadLocal threadLocal, Object object, int n) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = n;
            int n4 = ThreadLocalMap.prevIndex(n, n2);
            while ((entry = entryArray[n4]) != null) {
                if (entry.get() == null) {
                    n3 = n4;
                }
                n4 = ThreadLocalMap.prevIndex(n4, n2);
            }
            n4 = ThreadLocalMap.nextIndex(n, n2);
            while ((entry = entryArray[n4]) != null) {
                ThreadLocal threadLocal2 = (ThreadLocal)entry.get();
                if (threadLocal2 == threadLocal) {
                    entry.value = object;
                    entryArray[n4] = entryArray[n];
                    entryArray[n] = entry;
                    if (n3 == n) {
                        n3 = n4;
                    }
                    this.cleanSomeSlots(this.expungeStaleEntry(n3), n2);
                    return;
                }
                if (threadLocal2 == null && n3 == n) {
                    n3 = n4;
                }
                n4 = ThreadLocalMap.nextIndex(n4, n2);
            }
            entryArray[n].value = null;
            entryArray[n] = new Entry(threadLocal, object);
            if (n3 != n) {
                this.cleanSomeSlots(this.expungeStaleEntry(n3), n2);
            }
        }

        private int expungeStaleEntry(int n) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            entryArray[n].value = null;
            entryArray[n] = null;
            --this.size;
            int n3 = ThreadLocalMap.nextIndex(n, n2);
            while ((entry = entryArray[n3]) != null) {
                ThreadLocal threadLocal = (ThreadLocal)entry.get();
                if (threadLocal == null) {
                    entry.value = null;
                    entryArray[n3] = null;
                    --this.size;
                } else {
                    int n4 = threadLocal.threadLocalHashCode & n2 - 1;
                    if (n4 != n3) {
                        entryArray[n3] = null;
                        while (entryArray[n4] != null) {
                            n4 = ThreadLocalMap.nextIndex(n4, n2);
                        }
                        entryArray[n4] = entry;
                    }
                }
                n3 = ThreadLocalMap.nextIndex(n3, n2);
            }
            return n3;
        }

        private boolean cleanSomeSlots(int n, int n2) {
            boolean bl = false;
            Entry[] entryArray = this.table;
            int n3 = entryArray.length;
            do {
                Entry entry;
                if ((entry = entryArray[n = ThreadLocalMap.nextIndex(n, n3)]) == null || entry.get() != null) continue;
                n2 = n3;
                bl = true;
                n = this.expungeStaleEntry(n);
            } while ((n2 >>>= 1) != 0);
            return bl;
        }

        private void rehash() {
            this.expungeStaleEntries();
            if (this.size >= this.threshold - this.threshold / 4) {
                this.resize();
            }
        }

        private void resize() {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = n * 2;
            Entry[] entryArray2 = new Entry[n2];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Entry entry = entryArray[i];
                if (entry == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)entry.get();
                if (threadLocal == null) {
                    entry.value = null;
                    continue;
                }
                int n4 = threadLocal.threadLocalHashCode & n2 - 1;
                while (entryArray2[n4] != null) {
                    n4 = ThreadLocalMap.nextIndex(n4, n2);
                }
                entryArray2[n4] = entry;
                ++n3;
            }
            this.setThreshold(n2);
            this.size = n3;
            this.table = entryArray2;
        }

        private void expungeStaleEntries() {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            for (int i = 0; i < n; ++i) {
                Entry entry = entryArray[i];
                if (entry == null || entry.get() != null) continue;
                this.expungeStaleEntry(i);
            }
        }

        static class Entry
        extends WeakReference<ThreadLocal> {
            Object value;

            Entry(ThreadLocal threadLocal, Object object) {
                super(threadLocal);
                this.value = object;
            }
        }
    }
}

