/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.FilterGeneric;
import java.lang.invoke.FromGeneric;
import java.lang.invoke.InvokeGeneric;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.SpreadGeneric;
import java.lang.invoke.ToGeneric;
import sun.invoke.util.Wrapper;

class MethodTypeForm {
    final int[] argToSlotTable;
    final int[] slotToArgTable;
    final long argCounts;
    final long primCounts;
    final int vmslots;
    private Object vmlayout;
    final MethodType erasedType;
    MethodType primsAsBoxes;
    MethodType primArgsAsBoxes;
    MethodType primsAsInts;
    MethodType primsAsLongs;
    MethodType primsAtEnd;
    ToGeneric toGeneric;
    FromGeneric fromGeneric;
    SpreadGeneric[] spreadGeneric;
    FilterGeneric filterGeneric;
    MethodHandle genericInvoker;
    public static final int NO_CHANGE = 0;
    public static final int ERASE = 1;
    public static final int WRAP = 2;
    public static final int UNWRAP = 3;
    public static final int INTS = 4;
    public static final int LONGS = 5;
    public static final int RAW_RETURN = 6;

    public MethodType erasedType() {
        return this.erasedType;
    }

    protected MethodTypeForm(MethodType methodType) {
        int n;
        int n2;
        this.erasedType = methodType;
        Class<?>[] classArray = methodType.ptypes();
        int n3 = n2 = classArray.length;
        int n4 = 1;
        int n5 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Class<?>[] classArray2 = classArray;
        for (int i = 0; i < classArray2.length; ++i) {
            Class<?> clazz = classArray2[i];
            if (clazz == Object.class) continue;
            assert (clazz.isPrimitive());
            ++n6;
            if (!MethodTypeForm.hasTwoArgSlots(clazz)) continue;
            ++n7;
        }
        n3 += n7;
        Class<?> clazz = methodType.returnType();
        if (clazz != Object.class) {
            ++n8;
            if (MethodTypeForm.hasTwoArgSlots(clazz)) {
                ++n9;
            }
            if (clazz == Void.TYPE) {
                n5 = 0;
                n4 = 0;
            } else {
                n5 += n9;
            }
        }
        if (n7 != 0) {
            int n10 = n2 + n7;
            nArray2 = new int[n10 + 1];
            nArray = new int[1 + n2];
            nArray[0] = n10;
            for (n = 0; n < classArray2.length; ++n) {
                Class<?> clazz2 = classArray2[n];
                if (MethodTypeForm.hasTwoArgSlots(clazz2)) {
                    --n10;
                }
                nArray2[--n10] = n + 1;
                nArray[1 + n] = n10;
            }
            assert (n10 == 0);
        }
        this.primCounts = MethodTypeForm.pack(n9, n8, n7, n6);
        this.argCounts = MethodTypeForm.pack(n5, n4, n3, n2);
        if (nArray2 == null) {
            int n11 = n2;
            nArray2 = new int[n11 + 1];
            nArray = new int[1 + n2];
            nArray[0] = n11;
            for (n = 0; n < n2; ++n) {
                nArray2[--n11] = n + 1;
                nArray[1 + n] = n11;
            }
        }
        this.argToSlotTable = nArray;
        this.slotToArgTable = nArray2;
        if (n3 >= 256) {
            throw MethodHandleStatics.newIllegalArgumentException("too many arguments");
        }
        this.vmslots = this.parameterSlotCount();
        if (!this.hasPrimitives()) {
            this.primsAsBoxes = methodType;
            this.primArgsAsBoxes = methodType;
            this.primsAsInts = methodType;
            this.primsAsLongs = methodType;
            this.primsAtEnd = methodType;
        }
    }

    public MethodType primsAsBoxes() {
        MethodType methodType = this.primsAsBoxes;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeForm.canonicalize(this.erasedType, 2, 2);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primsAsBoxes = methodType;
        return this.primsAsBoxes;
    }

    public MethodType primArgsAsBoxes() {
        MethodType methodType = this.primArgsAsBoxes;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeForm.canonicalize(this.erasedType, 6, 2);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primArgsAsBoxes = methodType;
        return this.primArgsAsBoxes;
    }

    public MethodType primsAsInts() {
        MethodType methodType = this.primsAsInts;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeForm.canonicalize(methodType2, 6, 4);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primsAsInts = methodType;
        return this.primsAsInts;
    }

    public MethodType primsAsLongs() {
        MethodType methodType = this.primsAsLongs;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeForm.canonicalize(methodType2, 6, 5);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primsAsLongs = methodType;
        return this.primsAsLongs;
    }

    public MethodType primsAtEnd() {
        MethodType methodType = this.primsAtEnd;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        int n = this.primitiveParameterCount();
        if (n == 0) {
            this.primsAtEnd = methodType2;
            return this.primsAtEnd;
        }
        int n2 = this.parameterCount();
        int n3 = this.longPrimitiveParameterCount();
        if (n == n2 && (n3 == 0 || n3 == n2)) {
            this.primsAtEnd = methodType2;
            return this.primsAtEnd;
        }
        int[] nArray = MethodTypeForm.primsAtEndOrder(methodType2);
        this.primsAtEnd = methodType = MethodTypeForm.reorderParameters(methodType2, nArray, null);
        return this.primsAtEnd;
    }

    public static int[] primsAtEndOrder(MethodType methodType) {
        MethodTypeForm methodTypeForm = methodType.form();
        if (methodTypeForm.primsAtEnd == methodTypeForm.erasedType) {
            return null;
        }
        int n = methodTypeForm.parameterCount();
        int[] nArray = new int[n];
        int n2 = methodTypeForm.primitiveParameterCount();
        int n3 = methodTypeForm.longPrimitiveParameterCount();
        int n4 = 0;
        int n5 = n - n2;
        int n6 = n - n3;
        Class<?>[] classArray = methodType.ptypes();
        boolean bl = false;
        int n7 = 0;
        while (n7 < classArray.length) {
            Class<?> clazz = classArray[n7];
            int n8 = !clazz.isPrimitive() ? n4++ : (!MethodTypeForm.hasTwoArgSlots(clazz) ? n5++ : n6++);
            if (n8 != n7) {
                bl = true;
            }
            assert (nArray[n8] == 0);
            nArray[n8] = n7++;
        }
        assert (n4 == n - n2 && n5 == n - n3 && n6 == n);
        if (!bl) {
            methodTypeForm.primsAtEnd = methodTypeForm.erasedType;
            return null;
        }
        return nArray;
    }

    public static MethodType reorderParameters(MethodType methodType, int[] nArray, Class<?>[] classArray) {
        if (nArray == null) {
            return methodType;
        }
        Class<?>[] classArray2 = methodType.ptypes();
        Class[] classArray3 = new Class[nArray.length];
        int n = classArray2.length + (classArray == null ? 0 : classArray.length);
        boolean bl = classArray3.length != classArray2.length;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 != i) {
                bl = true;
            }
            Class<?> clazz = n2 < classArray2.length ? classArray2[n2] : (n2 == n ? methodType.returnType() : classArray[n2 - classArray2.length]);
            classArray3[i] = clazz;
        }
        if (!bl) {
            return methodType;
        }
        return MethodType.makeImpl(methodType.returnType(), classArray3, true);
    }

    private static boolean hasTwoArgSlots(Class<?> clazz) {
        return clazz == Long.TYPE || clazz == Double.TYPE;
    }

    private static long pack(int n, int n2, int n3, int n4) {
        assert (((n | n2 | n3 | n4) & 0xFFFF0000) == 0);
        long l = n << 16 | n2;
        long l2 = n3 << 16 | n4;
        return l << 32 | l2;
    }

    private static char unpack(long l, int n) {
        assert (n <= 3);
        return (char)(l >> (3 - n) * 16);
    }

    public int parameterCount() {
        return MethodTypeForm.unpack(this.argCounts, 3);
    }

    public int parameterSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 2);
    }

    public int returnCount() {
        return MethodTypeForm.unpack(this.argCounts, 1);
    }

    public int returnSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 0);
    }

    public int primitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 3);
    }

    public int longPrimitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 2);
    }

    public int primitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 1);
    }

    public int longPrimitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 0);
    }

    public boolean hasPrimitives() {
        return this.primCounts != 0L;
    }

    public boolean hasLongPrimitives() {
        return (this.longPrimitiveParameterCount() | this.longPrimitiveReturnCount()) != 0;
    }

    public int parameterToArgSlot(int n) {
        return this.argToSlotTable[1 + n];
    }

    public int argSlotToParameter(int n) {
        return this.slotToArgTable[n] - 1;
    }

    static MethodTypeForm findForm(MethodType methodType) {
        MethodType methodType2 = MethodTypeForm.canonicalize(methodType, 1, 1);
        if (methodType2 == null) {
            return new MethodTypeForm(methodType);
        }
        return methodType2.form();
    }

    public static MethodType canonicalize(MethodType methodType, int n, int n2) {
        Class<?>[] classArray = methodType.ptypes();
        Class<?>[] classArray2 = MethodTypeForm.canonicalizes(classArray, n2);
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = MethodTypeForm.canonicalize(clazz, n);
        if (classArray2 == null && clazz2 == null) {
            return null;
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        if (classArray2 == null) {
            classArray2 = classArray;
        }
        return MethodType.makeImpl(clazz2, classArray2, true);
    }

    static Class<?> canonicalize(Class<?> clazz, int n) {
        if (clazz != Object.class) {
            if (!clazz.isPrimitive()) {
                switch (n) {
                    case 3: {
                        Class<?> clazz2 = Wrapper.asPrimitiveType(clazz);
                        if (clazz2 == clazz) break;
                        return clazz2;
                    }
                    case 1: 
                    case 6: {
                        return Object.class;
                    }
                }
            } else if (clazz == Void.TYPE) {
                switch (n) {
                    case 6: {
                        return Integer.TYPE;
                    }
                    case 2: {
                        return Void.class;
                    }
                }
            } else {
                switch (n) {
                    case 2: {
                        return Wrapper.asWrapperType(clazz);
                    }
                    case 4: {
                        if (clazz == Integer.TYPE || clazz == Long.TYPE) {
                            return null;
                        }
                        if (clazz == Double.TYPE) {
                            return Long.TYPE;
                        }
                        return Integer.TYPE;
                    }
                    case 5: {
                        if (clazz == Long.TYPE) {
                            return null;
                        }
                        return Long.TYPE;
                    }
                    case 6: {
                        if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE) {
                            return null;
                        }
                        return Integer.TYPE;
                    }
                }
            }
        }
        return null;
    }

    static Class<?>[] canonicalizes(Class<?>[] classArray, int n) {
        Class[] classArray2 = null;
        int n2 = classArray.length;
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz = MethodTypeForm.canonicalize(classArray[i], n);
            if (clazz == Void.TYPE) {
                clazz = null;
            }
            if (clazz == null) continue;
            if (classArray2 == null) {
                classArray2 = (Class[])classArray.clone();
            }
            classArray2[i] = clazz;
        }
        return classArray2;
    }

    void notifyGenericMethodType() {
        if (this.genericInvoker != null) {
            return;
        }
        try {
            this.genericInvoker = InvokeGeneric.generalInvokerOf((MethodType)this.erasedType);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Exception while resolving inexact invoke");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public String toString() {
        return "Form" + this.erasedType;
    }
}

