/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int n) {
        int n2 = 8;
        if (n >= n2) {
            n2 = n;
            n2 |= n2 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
            n2 |= n2 >>> 16;
            if (++n2 < 0) {
                n2 >>>= 1;
            }
        }
        this.elements = new Object[n2];
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int n = this.head;
        int n2 = this.elements.length;
        int n3 = n2 - n;
        int n4 = n2 << 1;
        if (n4 < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] objectArray = new Object[n4];
        System.arraycopy(this.elements, n, objectArray, 0, n3);
        System.arraycopy(this.elements, 0, objectArray, n3, n);
        this.elements = objectArray;
        this.head = 0;
        this.tail = n2;
    }

    private <T> T[] copyElements(T[] TArray) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, TArray, 0, this.size());
        } else if (this.head > this.tail) {
            int n = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, TArray, 0, n);
            System.arraycopy(this.elements, 0, TArray, n, this.tail);
        }
        return TArray;
    }

    public ArrayDeque() {
        this.elements = new Object[16];
    }

    public ArrayDeque(int n) {
        this.allocateElements(n);
    }

    public ArrayDeque(Collection<? extends E> collection) {
        this.allocateElements(collection.size());
        this.addAll(collection);
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E pollFirst() {
        int n = this.head;
        E e = this.elements[n];
        if (e == null) {
            return null;
        }
        this.elements[n] = null;
        this.head = n + 1 & this.elements.length - 1;
        return e;
    }

    @Override
    public E pollLast() {
        int n = this.tail - 1 & this.elements.length - 1;
        E e = this.elements[n];
        if (e == null) {
            return null;
        }
        this.elements[n] = null;
        this.tail = n;
        return e;
    }

    @Override
    public E getFirst() {
        E e = this.elements[this.head];
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        E e = this.elements[this.tail - 1 & this.elements.length - 1];
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E peekFirst() {
        return this.elements[this.head];
    }

    @Override
    public E peekLast() {
        return this.elements[this.tail - 1 & this.elements.length - 1];
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        E e;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((e = this.elements[n2]) != null) {
            if (object.equals(e)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        E e;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.tail - 1 & n;
        while ((e = this.elements[n2]) != null) {
            if (object.equals(e)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 - 1 & n;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    private void checkInvariants() {
        assert (this.elements[this.tail] == null);
        assert (this.head != this.tail ? this.elements[this.head] != null && this.elements[this.tail - 1 & this.elements.length - 1] != null : this.elements[this.head] == null);
        assert (this.elements[this.head - 1 & this.elements.length - 1] == null);
    }

    private boolean delete(int n) {
        this.checkInvariants();
        E[] EArray = this.elements;
        int n2 = EArray.length - 1;
        int n3 = this.head;
        int n4 = this.tail;
        int n5 = n - n3 & n2;
        int n6 = n4 - n & n2;
        if (n5 >= (n4 - n3 & n2)) {
            throw new ConcurrentModificationException();
        }
        if (n5 < n6) {
            if (n3 <= n) {
                System.arraycopy(EArray, n3, EArray, n3 + 1, n5);
            } else {
                System.arraycopy(EArray, 0, EArray, 1, n);
                EArray[0] = EArray[n2];
                System.arraycopy(EArray, n3, EArray, n3 + 1, n2 - n3);
            }
            EArray[n3] = null;
            this.head = n3 + 1 & n2;
            return false;
        }
        if (n < n4) {
            System.arraycopy(EArray, n + 1, EArray, n, n6);
            this.tail = n4 - 1;
        } else {
            System.arraycopy(EArray, n + 1, EArray, n, n2 - n);
            EArray[n2] = EArray[0];
            System.arraycopy(EArray, 1, EArray, 0, n4);
            this.tail = n4 - 1 & n2;
        }
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DeqIterator(this, null);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator(this, null);
    }

    @Override
    public boolean contains(Object object) {
        E e;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((e = this.elements[n2]) != null) {
            if (object.equals(e)) {
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n != n2) {
            this.tail = 0;
            this.head = 0;
            int n3 = n;
            int n4 = this.elements.length - 1;
            do {
                this.elements[n3] = null;
            } while ((n3 = n3 + 1 & n4) != n2);
        }
    }

    @Override
    public Object[] toArray() {
        return this.copyElements(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        this.copyElements(objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public ArrayDeque<E> clone() {
        try {
            ArrayDeque arrayDeque = (ArrayDeque)super.clone();
            arrayDeque.elements = Arrays.copyOf(this.elements, this.elements.length);
            return arrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        int n = this.elements.length - 1;
        int n2 = this.head;
        while (n2 != this.tail) {
            objectOutputStream.writeObject(this.elements[n2]);
            n2 = n2 + 1 & n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.allocateElements(n);
        this.head = 0;
        this.tail = n;
        for (int i = 0; i < n; ++i) {
            this.elements[i] = objectInputStream.readObject();
        }
    }

    static /* synthetic */ int access$200(ArrayDeque arrayDeque) {
        return arrayDeque.head;
    }

    static /* synthetic */ int access$300(ArrayDeque arrayDeque) {
        return arrayDeque.tail;
    }

    static /* synthetic */ Object[] access$400(ArrayDeque arrayDeque) {
        return arrayDeque.elements;
    }

    static /* synthetic */ boolean access$500(ArrayDeque arrayDeque, int n) {
        return arrayDeque.delete(n);
    }

    private class DeqIterator
    implements Iterator<E> {
        int cursor;
        int remaining;
        int lastRet;

        DeqIterator() {
            this.remaining = ArrayDeque.this.size();
            this.lastRet = -1;
            this.cursor = ArrayDeque.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.inc((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        void postDelete(boolean leftShifted) {
            if (leftShifted) {
                this.cursor = ArrayDeque.dec((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.postDelete(ArrayDeque.this.delete(this.lastRet));
            this.lastRet = -1;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)ArrayDeque.this.tail, (int)this.cursor, (int)es.length) != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    ++i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.tail) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = 0;
                to = end;
            }
            this.lastRet = ArrayDeque.dec((int)end, (int)es.length);
        }
    }

    private class DescendingIterator
    extends DeqIterator {
        DescendingIterator() {
            this.cursor = ArrayDeque.dec((int)ArrayDeque.this.tail, (int)ArrayDeque.this.elements.length);
        }

        @Override
        public final E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.dec((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        @Override
        void postDelete(boolean leftShifted) {
            if (!leftShifted) {
                this.cursor = ArrayDeque.inc((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)this.cursor, (int)ArrayDeque.this.head, (int)es.length) + 1 != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.head;
            int n = to = i >= end ? end : 0;
            while (true) {
                if (i > to - 1) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    --i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.head) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = es.length - 1;
                to = end;
            }
            this.lastRet = end;
        }
    }
}

