/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.CallerSensitive;

public class Reflection {
    private static volatile Map<Class, String[]> fieldFilterMap;
    private static volatile Map<Class, String[]> methodFilterMap;

    @CallerSensitive
    public static native Class getCallerClass();

    @Deprecated
    @CallerSensitive
    public static Class getCallerClass(int n) {
        return Reflection.getCallerClass0(n);
    }

    @CallerSensitive
    private static native Class getCallerClass0(int var0);

    private static native int getClassAccessFlags(Class var0);

    public static boolean quickCheckMemberAccess(Class clazz, int n) {
        return Modifier.isPublic(Reflection.getClassAccessFlags(clazz) & n);
    }

    public static void ensureMemberAccess(Class clazz, Class clazz2, Object object, int n) throws IllegalAccessException {
        if (clazz == null || clazz2 == null) {
            throw new InternalError();
        }
        if (!Reflection.verifyMemberAccess(clazz, clazz2, object, n)) {
            throw new IllegalAccessException("Class " + clazz.getName() + " can not access a member of class " + clazz2.getName() + " with modifiers \"" + Modifier.toString(n) + "\"");
        }
    }

    public static boolean verifyMemberAccess(Class clazz, Class clazz2, Object object, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (clazz == clazz2) {
            return true;
        }
        if (!Modifier.isPublic(Reflection.getClassAccessFlags(clazz2))) {
            bl2 = Reflection.isSameClassPackage(clazz, clazz2);
            bl = true;
            if (!bl2) {
                return false;
            }
        }
        if (Modifier.isPublic(n)) {
            return true;
        }
        boolean bl3 = false;
        if (Modifier.isProtected(n) && Reflection.isSubclassOf(clazz, clazz2)) {
            bl3 = true;
        }
        if (!bl3 && !Modifier.isPrivate(n)) {
            if (!bl) {
                bl2 = Reflection.isSameClassPackage(clazz, clazz2);
                bl = true;
            }
            if (bl2) {
                bl3 = true;
            }
        }
        if (!bl3) {
            return false;
        }
        if (Modifier.isProtected(n)) {
            Class<?> clazz3;
            Class<?> clazz4 = clazz3 = object == null ? clazz2 : object.getClass();
            if (clazz3 != clazz) {
                if (!bl) {
                    bl2 = Reflection.isSameClassPackage(clazz, clazz2);
                    bl = true;
                }
                if (!bl2 && !Reflection.isSubclassOf(clazz3, clazz)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        return Reflection.isSameClassPackage(clazz.getClassLoader(), clazz.getName(), clazz2.getClassLoader(), clazz2.getName());
    }

    private static boolean isSameClassPackage(ClassLoader classLoader, String string, ClassLoader classLoader2, String string2) {
        int n;
        int n2;
        if (classLoader != classLoader2) {
            return false;
        }
        int n3 = string.lastIndexOf(46);
        int n4 = string2.lastIndexOf(46);
        if (n3 == -1 || n4 == -1) {
            return n3 == n4;
        }
        int n5 = 0;
        int n6 = 0;
        if (string.charAt(n5) == '[') {
            while (string.charAt(++n5) == '[') {
            }
            if (string.charAt(n5) != 'L') {
                throw new InternalError("Illegal class name " + string);
            }
        }
        if (string2.charAt(n6) == '[') {
            while (string2.charAt(++n6) == '[') {
            }
            if (string2.charAt(n6) != 'L') {
                throw new InternalError("Illegal class name " + string2);
            }
        }
        if ((n2 = n3 - n5) != (n = n4 - n6)) {
            return false;
        }
        return string.regionMatches(false, n5, string2, n6, n2);
    }

    static boolean isSubclassOf(Class clazz, Class clazz2) {
        while (clazz != null) {
            if (clazz == clazz2) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static synchronized void registerFieldsToFilter(Class clazz, String ... stringArray) {
        fieldFilterMap = Reflection.registerFilter(fieldFilterMap, clazz, stringArray);
    }

    public static synchronized void registerMethodsToFilter(Class clazz, String ... stringArray) {
        methodFilterMap = Reflection.registerFilter(methodFilterMap, clazz, stringArray);
    }

    private static Map<Class, String[]> registerFilter(Map<Class, String[]> map, Class clazz, String ... stringArray) {
        if (map.get(clazz) != null) {
            throw new IllegalArgumentException("Filter already registered: " + clazz);
        }
        map = new HashMap<Class, String[]>(map);
        map.put(clazz, stringArray);
        return map;
    }

    public static Field[] filterFields(Class clazz, Field[] fieldArray) {
        if (fieldFilterMap == null) {
            return fieldArray;
        }
        return (Field[])Reflection.filter(fieldArray, fieldFilterMap.get(clazz));
    }

    public static Method[] filterMethods(Class clazz, Method[] methodArray) {
        if (methodFilterMap == null) {
            return methodArray;
        }
        return (Method[])Reflection.filter(methodArray, methodFilterMap.get(clazz));
    }

    private static Member[] filter(Member[] memberArray, String[] stringArray) {
        if (stringArray == null || memberArray.length == 0) {
            return memberArray;
        }
        int n = 0;
        for (Member member : memberArray) {
            int n2 = 0;
            for (String string : stringArray) {
                if (member.getName() != string) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            ++n;
        }
        Member[] memberArray2 = (Member[])Array.newInstance(memberArray[0].getClass(), n);
        int n3 = 0;
        for (Member member : memberArray) {
            int n4 = 0;
            for (String string : stringArray) {
                if (member.getName() != string) continue;
                n4 = 1;
                break;
            }
            if (n4 != 0) continue;
            memberArray2[n3++] = member;
        }
        return memberArray2;
    }

    public static boolean isCallerSensitive(Method method) {
        ClassLoader classLoader = method.getDeclaringClass().getClassLoader();
        if (classLoader == null || Reflection.isExtClassLoader(classLoader)) {
            return method.isAnnotationPresent(CallerSensitive.class);
        }
        return false;
    }

    private static boolean isExtClassLoader(ClassLoader classLoader) {
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            if (classLoader2.getParent() != null || classLoader2 != classLoader) continue;
            return true;
        }
        return false;
    }

    static {
        HashMap<Class, String[]> hashMap = new HashMap<Class, String[]>();
        hashMap.put(Reflection.class, new String[]{"fieldFilterMap", "methodFilterMap"});
        hashMap.put(System.class, new String[]{"security"});
        fieldFilterMap = hashMap;
        methodFilterMap = new HashMap<Class, String[]>();
    }
}

