/*
 * Decompiled with CFR 0.152.
 */
package sun.util.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.LoggingSupport;
import sun.util.logging.PlatformLogger;

public class PlatformLogger {
    public static final int OFF = Integer.MAX_VALUE;
    public static final int SEVERE = 1000;
    public static final int WARNING = 900;
    public static final int INFO = 800;
    public static final int CONFIG = 700;
    public static final int FINE = 500;
    public static final int FINER = 400;
    public static final int FINEST = 300;
    public static final int ALL = Integer.MIN_VALUE;
    private static final int defaultLevel = 800;
    private static boolean loggingEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String string = System.getProperty("java.util.logging.config.class");
            String string2 = System.getProperty("java.util.logging.config.file");
            return string != null || string2 != null;
        }
    });
    private static Map<String, WeakReference<PlatformLogger>> loggers = new HashMap<String, WeakReference<PlatformLogger>>();
    private volatile LoggerProxy logger;

    public static synchronized PlatformLogger getLogger(String string) {
        PlatformLogger platformLogger = null;
        WeakReference<PlatformLogger> weakReference = loggers.get(string);
        if (weakReference != null) {
            platformLogger = (PlatformLogger)weakReference.get();
        }
        if (platformLogger == null) {
            platformLogger = new PlatformLogger(string);
            loggers.put(string, new WeakReference<PlatformLogger>(platformLogger));
        }
        return platformLogger;
    }

    public static synchronized void redirectPlatformLoggers() {
        if (loggingEnabled || !LoggingSupport.isAvailable()) {
            return;
        }
        loggingEnabled = true;
        for (Map.Entry<String, WeakReference<PlatformLogger>> entry : loggers.entrySet()) {
            WeakReference<PlatformLogger> weakReference = entry.getValue();
            PlatformLogger platformLogger = (PlatformLogger)weakReference.get();
            if (platformLogger == null) continue;
            platformLogger.newJavaLogger();
        }
    }

    private void newJavaLogger() {
        this.logger = new JavaLogger(this.logger.name, this.logger.effectiveLevel);
    }

    private PlatformLogger(String string) {
        this.logger = loggingEnabled ? new JavaLogger(string) : new LoggerProxy(string);
    }

    public boolean isEnabled() {
        return this.logger.isEnabled();
    }

    public String getName() {
        return this.logger.name;
    }

    public boolean isLoggable(int n) {
        return this.logger.isLoggable(n);
    }

    public int getLevel() {
        return this.logger.getLevel();
    }

    public void setLevel(int n) {
        this.logger.setLevel(n);
    }

    public void severe(String string) {
        this.logger.doLog(1000, string);
    }

    public void severe(String string, Throwable throwable) {
        this.logger.doLog(1000, string, throwable);
    }

    public void severe(String string, Object ... objectArray) {
        this.logger.doLog(1000, string, objectArray);
    }

    public void warning(String string) {
        this.logger.doLog(900, string);
    }

    public void warning(String string, Throwable throwable) {
        this.logger.doLog(900, string, throwable);
    }

    public void warning(String string, Object ... objectArray) {
        this.logger.doLog(900, string, objectArray);
    }

    public void info(String string) {
        this.logger.doLog(800, string);
    }

    public void info(String string, Throwable throwable) {
        this.logger.doLog(800, string, throwable);
    }

    public void info(String string, Object ... objectArray) {
        this.logger.doLog(800, string, objectArray);
    }

    public void config(String string) {
        this.logger.doLog(700, string);
    }

    public void config(String string, Throwable throwable) {
        this.logger.doLog(700, string, throwable);
    }

    public void config(String string, Object ... objectArray) {
        this.logger.doLog(700, string, objectArray);
    }

    public void fine(String string) {
        this.logger.doLog(500, string);
    }

    public void fine(String string, Throwable throwable) {
        this.logger.doLog(500, string, throwable);
    }

    public void fine(String string, Object ... objectArray) {
        this.logger.doLog(500, string, objectArray);
    }

    public void finer(String string) {
        this.logger.doLog(400, string);
    }

    public void finer(String string, Throwable throwable) {
        this.logger.doLog(400, string, throwable);
    }

    public void finer(String string, Object ... objectArray) {
        this.logger.doLog(400, string, objectArray);
    }

    public void finest(String string) {
        this.logger.doLog(300, string);
    }

    public void finest(String string, Throwable throwable) {
        this.logger.doLog(300, string, throwable);
    }

    public void finest(String string, Object ... objectArray) {
        this.logger.doLog(300, string, objectArray);
    }

    private static String getLevelName(int n) {
        switch (n) {
            case 0x7FFFFFFF: {
                return "OFF";
            }
            case 1000: {
                return "SEVERE";
            }
            case 900: {
                return "WARNING";
            }
            case 800: {
                return "INFO";
            }
            case 700: {
                return "CONFIG";
            }
            case 500: {
                return "FINE";
            }
            case 400: {
                return "FINER";
            }
            case 300: {
                return "FINEST";
            }
            case -2147483648: {
                return "ALL";
            }
        }
        return "UNKNOWN";
    }

    static class LoggerProxy {
        private static final PrintStream defaultStream = System.err;
        final String name;
        volatile int levelValue;
        volatile int effectiveLevel = 0;
        private static final String formatString = LoggingSupport.getSimpleFormat(false);
        private Date date = new Date();

        LoggerProxy(String string) {
            this(string, 800);
        }

        LoggerProxy(String string, int n) {
            this.name = string;
            this.levelValue = n == 0 ? 800 : n;
        }

        boolean isEnabled() {
            return this.levelValue != Integer.MAX_VALUE;
        }

        int getLevel() {
            return this.effectiveLevel;
        }

        void setLevel(int n) {
            this.levelValue = n;
            this.effectiveLevel = n;
        }

        void doLog(int n, String string) {
            if (n < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            defaultStream.print(this.format(n, string, null));
        }

        void doLog(int n, String string, Throwable throwable) {
            if (n < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            defaultStream.print(this.format(n, string, throwable));
        }

        void doLog(int n, String string, Object ... objectArray) {
            if (n < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            String string2 = this.formatMessage(string, objectArray);
            defaultStream.print(this.format(n, string2, null));
        }

        public boolean isLoggable(int n) {
            return n >= this.levelValue && this.levelValue != Integer.MAX_VALUE;
        }

        private String formatMessage(String string, Object ... objectArray) {
            try {
                if (objectArray == null || objectArray.length == 0) {
                    return string;
                }
                if (string.indexOf("{0") >= 0 || string.indexOf("{1") >= 0 || string.indexOf("{2") >= 0 || string.indexOf("{3") >= 0) {
                    return MessageFormat.format(string, objectArray);
                }
                return string;
            }
            catch (Exception exception) {
                return string;
            }
        }

        private synchronized String format(int n, String string, Throwable throwable) {
            this.date.setTime(System.currentTimeMillis());
            String string2 = "";
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println();
                throwable.printStackTrace(printWriter);
                printWriter.close();
                string2 = stringWriter.toString();
            }
            return String.format(formatString, this.date, this.getCallerInfo(), this.name, PlatformLogger.getLevelName(n), string, string2);
        }

        private String getCallerInfo() {
            String string = null;
            String string2 = null;
            JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
            Throwable throwable = new Throwable();
            int n = javaLangAccess.getStackTraceDepth(throwable);
            String string3 = "sun.util.logging.PlatformLogger";
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = javaLangAccess.getStackTraceElement(throwable, i);
                String string4 = stackTraceElement.getClassName();
                if (bl) {
                    if (!string4.equals(string3)) continue;
                    bl = false;
                    continue;
                }
                if (string4.equals(string3)) continue;
                string = string4;
                string2 = stackTraceElement.getMethodName();
                break;
            }
            if (string != null) {
                return string + " " + string2;
            }
            return this.name;
        }
    }
}

