/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.support.util;

import com.alibaba.common.lang.SystemUtil;
import com.alipay.config.Config;
import com.alipay.config.Env;
import com.alipay.support.util.Cmd;
import com.alipay.support.util.SupportUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class RsaKey {
    public static String openssl;
    public static String txtedit;
    public static String openbrowser;

    static {
        openbrowser = "rundll32 url.dll,FileProtocolHandler ";
        openssl = "openssl\\bin\\openssl.exe";
        txtedit = "cmd /c start \"\" ";
        String os = SystemUtil.getOsInfo().getName();
        if (os.toLowerCase().contains("mac")) {
            openssl = "openssl";
            txtedit = "open -a TextEdit ";
            os = "mac";
            openbrowser = "open ";
        }
    }

    public static void main(String[] args) {
    }

    public static String mkRsaPublicKeyFile(String privateKeyFile, String keyLength) throws IOException, InterruptedException {
        if (!new File(privateKeyFile).exists()) {
            return null;
        }
        String dir = Config.KEY_SAVE_PATH;
        Cmd cmd = new Cmd();
        if (Env.isMac()) {
            cmd.exec(String.valueOf(openssl) + " rsa -in " + privateKeyFile + " -pubout -out " + dir + "\u5e94\u7528\u516c\u94a5" + keyLength + ".txt");
        } else {
            cmd.exec(String.valueOf(openssl) + " rsa -in \"" + privateKeyFile + "\" -pubout -out \"" + dir + "\u5e94\u7528\u516c\u94a5" + keyLength + ".txt" + "\"");
        }
        cmd.close();
        return new File(String.valueOf(dir) + "\u5e94\u7528\u516c\u94a5" + keyLength + ".txt").getAbsolutePath();
    }

    public static String mkTempRsaPublicKeyFile(String privateKeyFile, String keyLength) throws IOException, InterruptedException {
        if (!new File(privateKeyFile).exists()) {
            return null;
        }
        String dir = Config.KEY_SAVE_PATH;
        String timestr = String.valueOf(new Date().getTime());
        Cmd cmd = new Cmd();
        if (Env.isMac()) {
            cmd.exec(String.valueOf(openssl) + " rsa -in " + privateKeyFile + " -pubout -out " + dir + "\u5e94\u7528\u516c\u94a5" + keyLength + timestr + ".txt");
        } else {
            cmd.exec(String.valueOf(openssl) + " rsa -in \"" + privateKeyFile + "\" -pubout -out \"" + dir + "\u5e94\u7528\u516c\u94a5" + keyLength + timestr + ".txt" + "\"");
        }
        cmd.close();
        return new File(String.valueOf(dir) + "\u5e94\u7528\u516c\u94a5" + keyLength + timestr + ".txt").getAbsolutePath();
    }

    public static String getKeyFromFile(String file) throws Exception {
        String key = "";
        try {
            key = SupportUtil.readFileAsString(file);
        }
        catch (FileNotFoundException ex) {
            return key;
        }
        key = RsaKey.getOriginalKey(key);
        return key;
    }

    public static String getOriginalKey(String key) {
        key = key.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        key = SupportUtil.filterSpaceTab(key);
        key = SupportUtil.filterLineSeparator(key);
        return key;
    }

    public static String convert2KeyFile(String key, String keyLength) {
        String key_file_content = "";
        String fileName = Config.KEY_SAVE_PATH;
        if (!SupportUtil.isExists(fileName)) {
            SupportUtil.mkDir(fileName);
        }
        int rsaType = RsaKey.check_rsa_type(key);
        switch (rsaType) {
            case 1: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN RSA PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END RSA PRIVATE KEY-----\n";
                break;
            }
            case 2: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PRIVATE KEY-----\n";
                break;
            }
            case 3: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u516c\u94a5";
                key_file_content = "-----BEGIN PUBLIC KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PUBLIC KEY-----\n";
                break;
            }
            case 4: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN RSA PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END RSA PRIVATE KEY-----\n";
                break;
            }
            case 5: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PRIVATE KEY-----\n";
                break;
            }
            case 6: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u516c\u94a5";
                key_file_content = "-----BEGIN PUBLIC KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PUBLIC KEY-----\n";
            }
        }
        if (!StringUtils.isEmpty((String)fileName)) {
            fileName = String.valueOf(fileName) + keyLength + ".txt";
            String file = new File(fileName).getAbsolutePath();
            try {
                SupportUtil.writeFileString(file, key_file_content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }
        return "";
    }

    public static String convert2TempKeyFile(String key, String keyLength) {
        String key_file_content = "";
        String fileName = Config.KEY_SAVE_PATH;
        if (!SupportUtil.isExists(fileName)) {
            SupportUtil.mkDir(fileName);
        }
        int rsaType = RsaKey.check_rsa_type(key);
        switch (rsaType) {
            case 1: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN RSA PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END RSA PRIVATE KEY-----\n";
                break;
            }
            case 2: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PRIVATE KEY-----\n";
                break;
            }
            case 3: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u516c\u94a5";
                key_file_content = "-----BEGIN PUBLIC KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PUBLIC KEY-----\n";
                break;
            }
            case 4: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN RSA PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END RSA PRIVATE KEY-----\n";
                break;
            }
            case 5: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u79c1\u94a5";
                key_file_content = "-----BEGIN PRIVATE KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PRIVATE KEY-----\n";
                break;
            }
            case 6: {
                fileName = String.valueOf(fileName) + "\u5e94\u7528\u516c\u94a5";
                key_file_content = "-----BEGIN PUBLIC KEY-----\n" + RsaKey.split2Base64(key) + "\n-----END PUBLIC KEY-----\n";
            }
        }
        if (!StringUtils.isEmpty((String)fileName)) {
            fileName = String.valueOf(fileName) + keyLength + new Date().getTime() + ".txt";
            String file = new File(fileName).getAbsolutePath();
            try {
                SupportUtil.writeFileString(file, key_file_content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }
        return "";
    }

    public static int check_rsa_type(String key) {
        if (key.length() >= 810 && key.length() <= 820) {
            return 1;
        }
        if (key.length() >= 840 && key.length() <= 860) {
            return 2;
        }
        if (key.length() >= 210 && key.length() <= 220) {
            return 3;
        }
        if (key.length() >= 1580 && key.length() <= 1600) {
            return 4;
        }
        if (key.length() >= 1620 && key.length() <= 1630) {
            return 5;
        }
        if (key.length() >= 390 && key.length() <= 400) {
            return 6;
        }
        return 0;
    }

    public static String convert2pcks8(String priKey, String keyLength) throws Exception {
        String fileName = String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u79c1\u94a5_tmp.txt";
        priKey = RsaKey.split2Base64(priKey);
        priKey = "-----BEGIN RSA PRIVATE KEY-----\n" + priKey;
        priKey = String.valueOf(priKey) + "\n-----END RSA PRIVATE KEY-----\n";
        if (!SupportUtil.isExists(Config.KEY_SAVE_PATH)) {
            SupportUtil.mkDir(Config.KEY_SAVE_PATH);
        }
        SupportUtil.writeFileString(fileName, priKey);
        String file = RsaKey.mkPkcs8FromPrivate(fileName, keyLength);
        return RsaKey.getKeyFromFile(file);
    }

    public static String convertPcks82Original(String priKeyPkcs8, String keyLength) throws Exception {
        String fileName = String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u79c1\u94a5_tmp.txt";
        priKeyPkcs8 = RsaKey.split2Base64(priKeyPkcs8);
        priKeyPkcs8 = "-----BEGIN PRIVATE KEY-----\n" + priKeyPkcs8;
        priKeyPkcs8 = String.valueOf(priKeyPkcs8) + "\n-----END PRIVATE KEY-----\n";
        if (!SupportUtil.isExists(Config.KEY_SAVE_PATH)) {
            SupportUtil.mkDir(Config.KEY_SAVE_PATH);
        }
        SupportUtil.writeFileString(fileName, priKeyPkcs8);
        String file = RsaKey.mkPrivateFromPkcs8(fileName, keyLength);
        return RsaKey.getKeyFromFile(file);
    }

    public static String mkPrivateFromPkcs8(String privateKeyFile, String keyLength) throws IOException, InterruptedException {
        if (!new File(privateKeyFile).exists()) {
            return null;
        }
        String dir = Config.KEY_SAVE_PATH;
        Cmd cmd = new Cmd();
        String s = null;
        s = Env.isMac() ? String.valueOf(openssl) + " pkcs8 -inform PEM -in " + privateKeyFile + " -outform PEM -nocrypt -out " + dir + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt" : String.valueOf(openssl) + " pkcs8 -inform PEM -in \"" + privateKeyFile + "\" -outform PEM -nocrypt -out \"" + dir + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt" + "\"";
        cmd.exec(s);
        cmd.close();
        return new File(String.valueOf(dir) + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt").getAbsolutePath();
    }

    public static String mkPkcs8FromPrivate(String privateKeyFile, String keyLength) throws IOException, InterruptedException {
        if (!new File(privateKeyFile).exists()) {
            return null;
        }
        String dir = Config.KEY_SAVE_PATH;
        Cmd cmd = new Cmd();
        if (Env.isMac()) {
            cmd.exec(String.valueOf(openssl) + " pkcs8 -topk8 -inform PEM -in " + privateKeyFile + " -outform PEM -nocrypt -out " + dir + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt");
        } else {
            cmd.exec(String.valueOf(openssl) + " pkcs8 -topk8 -inform PEM -in \"" + privateKeyFile + "\" -outform PEM -nocrypt -out \"" + dir + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt" + "\"");
        }
        cmd.close();
        return new File(String.valueOf(dir) + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt").getAbsolutePath();
    }

    public static void openBrowserForUrl(String url) {
        if (Env.isMac()) {
            RsaKey.openMacURL(url);
        } else {
            RsaKey.openWindowsURL(url);
        }
    }

    public static void openMacURL(String url) {
        try {
            Runtime.getRuntime().exec(String.valueOf(openbrowser) + url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openWindowsURL(String url) {
        try {
            Runtime.getRuntime().exec(String.valueOf(openbrowser) + url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openTxtFile(String txtFileName) throws IOException, InterruptedException {
        String signStepFile = String.valueOf(Config.KEY_SAVE_PATH) + txtFileName + ".txt";
        if (!new File(signStepFile).exists()) {
            return;
        }
        if (Env.isMac()) {
            Runtime.getRuntime().exec(String.valueOf(txtedit) + signStepFile);
        } else {
            Runtime.getRuntime().exec(String.valueOf(txtedit) + "\"" + signStepFile + "\"");
        }
    }

    public static void appendTxtFile(String txtFileName, String content) throws IOException {
        if (!SupportUtil.isExists(Config.KEY_SAVE_PATH)) {
            SupportUtil.mkDir(Config.KEY_SAVE_PATH);
        }
        String signStepFile = String.valueOf(Config.KEY_SAVE_PATH) + txtFileName + ".txt";
        SupportUtil.appendFileString(signStepFile, content, "GBK");
    }

    public static void deleteTxtFile(String txtFileName) throws IOException {
        String signStepFile = String.valueOf(Config.KEY_SAVE_PATH) + txtFileName + ".txt";
        SupportUtil.delFile(signStepFile);
    }

    public static String readFile2String(String filePath) throws Exception {
        return SupportUtil.readFileAsString(filePath);
    }

    public static String split2Base64(String str) {
        str = str.split("\\n")[0];
        String base64 = "";
        while (str.length() >= 64) {
            base64 = String.valueOf(base64) + str.substring(0, 64) + "\n";
            str = str.substring(64);
        }
        base64 = String.valueOf(base64) + str;
        return base64.trim();
    }

    public static void clearHeadBottom(String keyLength) throws Exception {
        String tmpFilePath;
        File tmpFile;
        File tmpFile2;
        String privateKeyFilePath = String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u79c1\u94a5" + ".txt";
        String publicKeyFilePath = String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u516c\u94a5" + ".txt";
        String privateKey = RsaKey.getKeyFromFile(privateKeyFilePath);
        String publicKey = RsaKey.getKeyFromFile(publicKeyFilePath);
        if (StringUtils.isEmpty((String)publicKey)) {
            tmpFile2 = new File(publicKeyFilePath);
            if (tmpFile2.exists()) {
                tmpFile2.delete();
            }
        } else {
            SupportUtil.writeFileString(publicKeyFilePath, publicKey);
        }
        if (StringUtils.isEmpty((String)privateKey)) {
            tmpFile2 = new File(privateKeyFilePath);
            if (tmpFile2.exists()) {
                tmpFile2.delete();
            }
        } else {
            SupportUtil.writeFileString(privateKeyFilePath, privateKey);
        }
        if ((tmpFile = new File(tmpFilePath = String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u79c1\u94a5_tmp.txt")).exists()) {
            tmpFile.delete();
        }
    }

    public static String getKeyLength(String privateKey) {
        int keyFormat = RsaKey.check_rsa_type(privateKey);
        if (keyFormat == 5 || keyFormat == 4) {
            return "2048";
        }
        return "1024";
    }
}

