/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue = new ReferenceQueue();
    private static Finalizer unfinalized = null;
    private static final Object lock = new Object();
    private Finalizer next = null;
    private Finalizer prev = null;

    static native void invokeFinalizeMethod(Object var0) throws Throwable;

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    static void register(Object object) {
        new Finalizer(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer() {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            finalizer = this.get();
            if (finalizer != null && !(finalizer instanceof Enum)) {
                Finalizer.invokeFinalizeMethod(finalizer);
                finalizer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                ThreadGroup tg;
                ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                while (tgn != null) {
                    tg = tgn;
                    tgn = tg.getParent();
                }
                Thread sft = new Thread(tg, runnable, "Secondary finalizer", 0L, false);
                sft.start();
                try {
                    sft.join();
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        });
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            @Override
            public void run() {
                Finalizer f;
                if (this.running) {
                    return;
                }
                JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
                this.running = true;
                while ((f = (Finalizer)queue.poll()) != null) {
                    f.runFinalizer(jla);
                }
            }
        });
    }

    static void runAllFinalizers() {
        Finalizer.forkSecondaryFinalizer((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Object access$200() {
        return lock;
    }

    static /* synthetic */ Finalizer access$300() {
        return unfinalized;
    }

    static /* synthetic */ Finalizer access$302(Finalizer finalizer) {
        unfinalized = finalizer;
        return unfinalized;
    }

    static /* synthetic */ Finalizer access$400(Finalizer finalizer) {
        return finalizer.next;
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new FinalizerThread(threadGroup);
        ((Thread)object).setPriority(8);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static class FinalizerThread
    extends Thread {
        private volatile boolean running;

        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        @Override
        public void run() {
            if (this.running) {
                return;
            }
            this.running = true;
            while (true) {
                try {
                    while (true) {
                        Finalizer finalizer = (Finalizer)queue.remove();
                        finalizer.runFinalizer();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

