/*
 * Decompiled with CFR 0.152.
 */
package sun.dc;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import sun.awt.geom.PathConsumer2D;
import sun.dc.DuctusRenderingEngine;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;
import sun.dc.pr.Rasterizer;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;

public class DuctusRenderingEngine
extends RenderingEngine {
    static final float PenUnits = 0.01f;
    static final int MinPenUnits = 100;
    static final int MinPenUnitsAA = 20;
    static final float MinPenSizeAA = 0.19999999f;
    static final float UPPER_BND = 1.7014117E38f;
    static final float LOWER_BND = -1.7014117E38f;
    private static final int[] RasterizerCaps = new int[]{30, 10, 20};
    private static final int[] RasterizerCorners = new int[]{50, 10, 40};
    private static Rasterizer theRasterizer;

    static float[] getTransformMatrix(AffineTransform affineTransform) {
        float[] fArray = new float[4];
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i = 0; i < 4; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape createStrokedShape(Shape shape, float f, int n, int n2, float f2, float[] fArray, float f3) {
        FillAdapter fillAdapter = new FillAdapter(this);
        PathStroker pathStroker = new PathStroker((PathConsumer)fillAdapter);
        PathDasher pathDasher = null;
        try {
            PathStroker pathStroker2;
            pathStroker.setPenDiameter(f);
            pathStroker.setPenT4(null);
            pathStroker.setCaps(RasterizerCaps[n]);
            pathStroker.setCorners(RasterizerCorners[n2], f2);
            if (fArray != null) {
                pathDasher = new PathDasher((PathConsumer)pathStroker);
                pathDasher.setDash(fArray, f3);
                pathDasher.setDashT4(null);
                pathStroker2 = pathDasher;
            } else {
                pathStroker2 = pathStroker;
            }
            this.feedConsumer((PathConsumer)pathStroker2, shape.getPathIterator(null));
        }
        finally {
            pathStroker.dispose();
            if (pathDasher != null) {
                pathDasher.dispose();
            }
        }
        return fillAdapter.getShape();
    }

    @Override
    public void strokeTo(Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, boolean bl2, boolean bl3, PathConsumer2D pathConsumer2D) {
        Object object;
        PathStroker pathStroker;
        PathStroker pathStroker2 = pathStroker = new PathStroker(pathConsumer2D);
        float[] fArray = null;
        if (!bl) {
            pathStroker.setPenDiameter(basicStroke.getLineWidth());
            if (affineTransform != null) {
                fArray = DuctusRenderingEngine.getTransformMatrix(affineTransform);
            }
            pathStroker.setPenT4(fArray);
            pathStroker.setPenFitting(0.01f, 100);
        }
        pathStroker.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
        pathStroker.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
        float[] fArray2 = basicStroke.getDashArray();
        if (fArray2 != null) {
            object = new PathDasher((PathConsumer)pathStroker);
            object.setDash(fArray2, basicStroke.getDashPhase());
            if (affineTransform != null && fArray == null) {
                fArray = DuctusRenderingEngine.getTransformMatrix(affineTransform);
            }
            object.setDashT4(fArray);
            pathStroker2 = object;
        }
        try {
            object = shape.getPathIterator(affineTransform);
            DuctusRenderingEngine.feedConsumer((PathIterator)object, (PathConsumer)pathStroker2, bl2, 0.25f);
        }
        catch (PathException pathException) {
            throw new InternalError("Unable to Stroke shape (" + pathException.getMessage() + ")");
        }
        finally {
            while (pathStroker2 != null && pathStroker2 != pathConsumer2D) {
                PathConsumer pathConsumer = pathStroker2.getConsumer();
                pathStroker2.dispose();
                pathStroker2 = pathConsumer;
            }
        }
    }

    public static void feedConsumer(PathIterator pathIterator, PathConsumer pathConsumer, boolean bl, float f) throws PathException {
        pathConsumer.beginPath();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[] fArray = new float[6];
        float f4 = 0.5f - f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl2) {
                bl2 = false;
                if (n != 0) {
                    pathConsumer.beginSubpath(f2, f3);
                    bl4 = true;
                }
            }
            if (bl) {
                int n2;
                switch (n) {
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = -1;
                    }
                }
                if (n2 >= 0) {
                    float f7 = fArray[n2];
                    float f8 = fArray[n2 + 1];
                    float f9 = (float)Math.floor(f7 + f4) + f;
                    float f10 = (float)Math.floor(f8 + f4) + f;
                    fArray[n2] = f9;
                    fArray[n2 + 1] = f10;
                    f9 -= f7;
                    f10 -= f8;
                    switch (n) {
                        case 3: {
                            fArray[0] = fArray[0] + f5;
                            fArray[1] = fArray[1] + f6;
                            fArray[2] = fArray[2] + f9;
                            fArray[3] = fArray[3] + f10;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f9 + f5) / 2.0f;
                            fArray[1] = fArray[1] + (f10 + f6) / 2.0f;
                            break;
                        }
                    }
                    f5 = f9;
                    f6 = f10;
                }
            }
            switch (n) {
                case 0: {
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        f2 = fArray[0];
                        f3 = fArray[1];
                        pathConsumer.beginSubpath(f2, f3);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    bl3 = true;
                    break;
                }
                case 1: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    if (bl3) {
                        pathConsumer.beginSubpath(fArray[0], fArray[1]);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    pathConsumer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    if (!(fArray[2] < 1.7014117E38f) || !(fArray[2] > -1.7014117E38f) || !(fArray[3] < 1.7014117E38f) || !(fArray[3] > -1.7014117E38f)) break;
                    if (bl3) {
                        pathConsumer.beginSubpath(fArray[2], fArray[3]);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        pathConsumer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    pathConsumer.appendLine(fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    if (!(fArray[4] < 1.7014117E38f) || !(fArray[4] > -1.7014117E38f) || !(fArray[5] < 1.7014117E38f) || !(fArray[5] > -1.7014117E38f)) break;
                    if (bl3) {
                        pathConsumer.beginSubpath(fArray[4], fArray[5]);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f && fArray[2] < 1.7014117E38f && fArray[2] > -1.7014117E38f && fArray[3] < 1.7014117E38f && fArray[3] > -1.7014117E38f) {
                        pathConsumer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    pathConsumer.appendLine(fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    if (!bl4) break;
                    pathConsumer.closedSubpath();
                    bl4 = false;
                    bl2 = true;
                }
            }
            pathIterator.next();
        }
        pathConsumer.endPath();
    }

    public static synchronized Rasterizer getRasterizer() {
        Rasterizer rasterizer = theRasterizer;
        if (rasterizer == null) {
            rasterizer = new Rasterizer();
        } else {
            theRasterizer = null;
        }
        return rasterizer;
    }

    public static synchronized void dropRasterizer(Rasterizer rasterizer) {
        rasterizer.reset();
        theRasterizer = rasterizer;
    }

    @Override
    public float getMinimumAAPenSize() {
        return 0.19999999f;
    }

    @Override
    public AATileGenerator getAATileGenerator(Shape shape, AffineTransform affineTransform, Region region, BasicStroke basicStroke, boolean bl, boolean bl2, int[] nArray) {
        Rasterizer rasterizer = DuctusRenderingEngine.getRasterizer();
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        if (basicStroke != null) {
            float[] fArray = null;
            rasterizer.setUsage(3);
            if (bl) {
                rasterizer.setPenDiameter(0.19999999f);
            } else {
                rasterizer.setPenDiameter(basicStroke.getLineWidth());
                if (affineTransform != null) {
                    fArray = DuctusRenderingEngine.getTransformMatrix(affineTransform);
                    rasterizer.setPenT4(fArray);
                }
                rasterizer.setPenFitting(0.01f, 20);
            }
            rasterizer.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
            rasterizer.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
            float[] fArray2 = basicStroke.getDashArray();
            if (fArray2 != null) {
                rasterizer.setDash(fArray2, basicStroke.getDashPhase());
                if (affineTransform != null && fArray == null) {
                    fArray = DuctusRenderingEngine.getTransformMatrix(affineTransform);
                }
                rasterizer.setDashT4(fArray);
            }
        } else {
            rasterizer.setUsage(pathIterator.getWindingRule() == 0 ? 1 : 2);
        }
        rasterizer.beginPath();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = new float[6];
        float f3 = 0.0f;
        float f4 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl3) {
                bl3 = false;
                if (n != 0) {
                    rasterizer.beginSubpath(f, f2);
                    bl5 = true;
                }
            }
            if (bl2) {
                int n2;
                switch (n) {
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = -1;
                    }
                }
                if (n2 >= 0) {
                    float f5 = fArray[n2];
                    float f6 = fArray[n2 + 1];
                    float f7 = (float)Math.floor(f5) + 0.5f;
                    float f8 = (float)Math.floor(f6) + 0.5f;
                    fArray[n2] = f7;
                    fArray[n2 + 1] = f8;
                    f7 -= f5;
                    f8 -= f6;
                    switch (n) {
                        case 3: {
                            fArray[0] = fArray[0] + f3;
                            fArray[1] = fArray[1] + f4;
                            fArray[2] = fArray[2] + f7;
                            fArray[3] = fArray[3] + f8;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f7 + f3) / 2.0f;
                            fArray[1] = fArray[1] + (f8 + f4) / 2.0f;
                            break;
                        }
                    }
                    f3 = f7;
                    f4 = f8;
                }
            }
            switch (n) {
                case 0: {
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        f = fArray[0];
                        f2 = fArray[1];
                        rasterizer.beginSubpath(f, f2);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    bl4 = true;
                    break;
                }
                case 1: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    if (bl4) {
                        rasterizer.beginSubpath(fArray[0], fArray[1]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    rasterizer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    if (!(fArray[2] < 1.7014117E38f) || !(fArray[2] > -1.7014117E38f) || !(fArray[3] < 1.7014117E38f) || !(fArray[3] > -1.7014117E38f)) break;
                    if (bl4) {
                        rasterizer.beginSubpath(fArray[2], fArray[3]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        rasterizer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    rasterizer.appendLine(fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    if (!(fArray[4] < 1.7014117E38f) || !(fArray[4] > -1.7014117E38f) || !(fArray[5] < 1.7014117E38f) || !(fArray[5] > -1.7014117E38f)) break;
                    if (bl4) {
                        rasterizer.beginSubpath(fArray[4], fArray[5]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f && fArray[2] < 1.7014117E38f && fArray[2] > -1.7014117E38f && fArray[3] < 1.7014117E38f && fArray[3] > -1.7014117E38f) {
                        rasterizer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    rasterizer.appendLine(fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    if (!bl5) break;
                    rasterizer.closedSubpath();
                    bl5 = false;
                    bl3 = true;
                }
            }
            pathIterator.next();
        }
        try {
            rasterizer.endPath();
            rasterizer.getAlphaBox(nArray);
            region.clipBoxToBounds(nArray);
            if (nArray[0] >= nArray[2] || nArray[1] >= nArray[3]) {
                DuctusRenderingEngine.dropRasterizer(rasterizer);
                return null;
            }
            rasterizer.setOutputArea((float)nArray[0], (float)nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
        catch (PRException pRException) {
            System.err.println("DuctusRenderingEngine.getAATileGenerator: " + (Object)((Object)pRException));
        }
        return rasterizer;
    }

    @Override
    public AATileGenerator getAATileGenerator(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Region region, int[] nArray) {
        double d9;
        double d10;
        double d11;
        double d12;
        boolean bl;
        boolean bl2 = bl = d7 > 0.0 && d8 > 0.0;
        if (bl) {
            d12 = d3 * d7;
            d11 = d4 * d7;
            d10 = d5 * d8;
            d9 = d6 * d8;
            d -= (d12 + d10) / 2.0;
            d2 -= (d11 + d9) / 2.0;
            d3 += d12;
            d4 += d11;
            d5 += d10;
            d6 += d9;
            if (d7 > 1.0 && d8 > 1.0) {
                bl = false;
            }
        } else {
            d9 = 0.0;
            d10 = 0.0;
            d11 = 0.0;
            d12 = 0.0;
        }
        Rasterizer rasterizer = DuctusRenderingEngine.getRasterizer();
        rasterizer.setUsage(1);
        rasterizer.beginPath();
        rasterizer.beginSubpath((float)d, (float)d2);
        rasterizer.appendLine((float)(d + d3), (float)(d2 + d4));
        rasterizer.appendLine((float)(d + d3 + d5), (float)(d2 + d4 + d6));
        rasterizer.appendLine((float)(d + d5), (float)(d2 + d6));
        rasterizer.closedSubpath();
        if (bl) {
            rasterizer.beginSubpath((float)(d += d12 + d10), (float)(d2 += d11 + d9));
            rasterizer.appendLine((float)(d + (d3 -= 2.0 * d12)), (float)(d2 + (d4 -= 2.0 * d11)));
            rasterizer.appendLine((float)(d + d3 + (d5 -= 2.0 * d10)), (float)(d2 + d4 + (d6 -= 2.0 * d9)));
            rasterizer.appendLine((float)(d + d5), (float)(d2 + d6));
            rasterizer.closedSubpath();
        }
        try {
            rasterizer.endPath();
            rasterizer.getAlphaBox(nArray);
            region.clipBoxToBounds(nArray);
            if (nArray[0] >= nArray[2] || nArray[1] >= nArray[3]) {
                DuctusRenderingEngine.dropRasterizer(rasterizer);
                return null;
            }
            rasterizer.setOutputArea((float)nArray[0], (float)nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
        catch (PRException pRException) {
            System.err.println("DuctusRenderingEngine.getAATileGenerator: " + (Object)((Object)pRException));
        }
        return rasterizer;
    }

    private void feedConsumer(PathConsumer pathConsumer, PathIterator pathIterator) {
        try {
            pathConsumer.beginPath();
            boolean bl = false;
            float f = 0.0f;
            float f2 = 0.0f;
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(fArray);
                if (bl) {
                    bl = false;
                    if (n != 0) {
                        pathConsumer.beginSubpath(f, f2);
                    }
                }
                switch (n) {
                    case 0: {
                        f = fArray[0];
                        f2 = fArray[1];
                        pathConsumer.beginSubpath(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        pathConsumer.appendLine(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        pathConsumer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        pathConsumer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        pathConsumer.closedSubpath();
                        bl = true;
                    }
                }
                pathIterator.next();
            }
            pathConsumer.endPath();
        }
        catch (PathException pathException) {
            throw new InternalError("Unable to Stroke shape (" + pathException.getMessage() + ")");
        }
    }
}

