/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.security.AccessController;
import sun.misc.Perf;
import sun.misc.PerfCounter;

public class PerfCounter {
    private static final Perf perf = AccessController.doPrivileged(new Perf.GetPerfAction());
    private static final int V_Constant = 1;
    private static final int V_Monotonic = 2;
    private static final int V_Variable = 3;
    private static final int U_None = 1;
    private final String name;
    private final LongBuffer lb;

    private PerfCounter(String string, int n) {
        this.name = string;
        ByteBuffer byteBuffer = perf.createLong(string, 1, n, 0L);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.lb = byteBuffer.asLongBuffer();
    }

    static PerfCounter newPerfCounter(String string) {
        return new PerfCounter(string, 3);
    }

    static PerfCounter newConstantPerfCounter(String string) {
        PerfCounter perfCounter = new PerfCounter(string, 1);
        return perfCounter;
    }

    public synchronized long get() {
        return this.lb.get(0);
    }

    public synchronized void set(long l) {
        this.lb.put(0, l);
    }

    public synchronized void add(long l) {
        long l2 = this.get() + l;
        this.lb.put(0, l2);
    }

    public void increment() {
        this.add(1L);
    }

    public void addTime(long l) {
        this.add(l);
    }

    public void addElapsedTimeFrom(long l) {
        this.add(System.nanoTime() - l);
    }

    public String toString() {
        return this.name + " = " + this.get();
    }

    public static PerfCounter getFindClasses() {
        return CoreCounters.lc;
    }

    public static PerfCounter getFindClassTime() {
        return CoreCounters.lct;
    }

    public static PerfCounter getReadClassBytesTime() {
        return CoreCounters.rcbt;
    }

    public static PerfCounter getParentDelegationTime() {
        return CoreCounters.pdt;
    }

    public static PerfCounter getZipFileCount() {
        return CoreCounters.zfc;
    }

    public static PerfCounter getZipFileOpenTime() {
        return CoreCounters.zfot;
    }

    public static PerfCounter getD3DAvailable() {
        return WindowsClientCounters.d3dAvailable;
    }

    static class CoreCounters {
        static final PerfCounter pdt = PerfCounter.newPerfCounter("sun.classloader.parentDelegationTime");
        static final PerfCounter lc = PerfCounter.newPerfCounter("sun.classloader.findClasses");
        static final PerfCounter lct = PerfCounter.newPerfCounter("sun.classloader.findClassTime");
        static final PerfCounter rcbt = PerfCounter.newPerfCounter("sun.urlClassLoader.readClassBytesTime");
        static final PerfCounter zfc = PerfCounter.newPerfCounter("sun.zip.zipFiles");
        static final PerfCounter zfot = PerfCounter.newPerfCounter("sun.zip.zipFile.openTime");

        CoreCounters() {
        }
    }
}

