/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertificatePolicyId;

public class PolicyInformation {
    public static final String NAME = "PolicyInformation";
    public static final String ID = "id";
    public static final String QUALIFIERS = "qualifiers";
    private CertificatePolicyId policyIdentifier;
    private Set<PolicyQualifierInfo> policyQualifiers;

    public PolicyInformation(CertificatePolicyId certificatePolicyId, Set<PolicyQualifierInfo> set) throws IOException {
        if (set == null) {
            throw new NullPointerException("policyQualifiers is null");
        }
        this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>(set);
        this.policyIdentifier = certificatePolicyId;
    }

    public PolicyInformation(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding of PolicyInformation");
        }
        this.policyIdentifier = new CertificatePolicyId(derValue.data.getDerValue());
        if (derValue.data.available() != 0) {
            this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>();
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.tag != 48) {
                throw new IOException("Invalid encoding of PolicyInformation");
            }
            if (derValue2.data.available() == 0) {
                throw new IOException("No data available in policyQualifiers");
            }
            while (derValue2.data.available() != 0) {
                this.policyQualifiers.add(new PolicyQualifierInfo(derValue2.data.getDerValue().toByteArray()));
            }
        } else {
            this.policyQualifiers = Collections.emptySet();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof PolicyInformation)) {
            return false;
        }
        PolicyInformation policyInformation = (PolicyInformation)object;
        if (!this.policyIdentifier.equals(policyInformation.getPolicyIdentifier())) {
            return false;
        }
        return this.policyQualifiers.equals(policyInformation.getPolicyQualifiers());
    }

    public int hashCode() {
        int n = 37 + this.policyIdentifier.hashCode();
        n = 37 * n + this.policyQualifiers.hashCode();
        return n;
    }

    public CertificatePolicyId getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public Set<PolicyQualifierInfo> getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            return this.policyIdentifier;
        }
        if (string.equalsIgnoreCase(QUALIFIERS)) {
            return this.policyQualifiers;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by PolicyInformation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            if (!(object instanceof CertificatePolicyId)) throw new IOException("Attribute value must be instance of CertificatePolicyId.");
            this.policyIdentifier = (CertificatePolicyId)object;
            return;
        } else {
            if (!string.equalsIgnoreCase(QUALIFIERS)) throw new IOException("Attribute name [" + string + "] not recognized by PolicyInformation");
            if (this.policyIdentifier == null) {
                throw new IOException("Attribute must have a CertificatePolicyIdentifier value before PolicyQualifierInfo can be set.");
            }
            if (!(object instanceof Set)) throw new IOException("Attribute value must be of type Set.");
            for (Object e : (Set)object) {
                if (e instanceof PolicyQualifierInfo) continue;
                throw new IOException("Attribute value must be aSet of PolicyQualifierInfo objects.");
            }
            this.policyQualifiers = (Set)object;
        }
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(QUALIFIERS)) {
            if (string.equalsIgnoreCase(ID)) {
                throw new IOException("Attribute ID may not be deleted from PolicyInformation.");
            }
            throw new IOException("Attribute name [" + string + "] not recognized by PolicyInformation.");
        }
        this.policyQualifiers = Collections.emptySet();
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)ID);
        attributeNameEnumeration.addElement((Object)QUALIFIERS);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("  [" + this.policyIdentifier.toString());
        stringBuilder.append(this.policyQualifiers + "  ]\n");
        return stringBuilder.toString();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.policyIdentifier.encode(derOutputStream2);
        if (!this.policyQualifiers.isEmpty()) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            for (PolicyQualifierInfo policyQualifierInfo : this.policyQualifiers) {
                derOutputStream3.write(policyQualifierInfo.getEncoded());
            }
            derOutputStream2.write((byte)48, derOutputStream3);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }
}

