/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleDataMetaInfo;
import sun.util.resources.Bundles;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public class LocaleData {
    private static final String localeDataJarName = "localedata.jar";

    public static Locale[] getAvailableLocales() {
        return (Locale[])AvailableLocales.localeList.clone();
    }

    public static ResourceBundle getCalendarData(Locale locale) {
        return LocaleData.getBundle("sun.util.resources.CalendarData", locale);
    }

    public static OpenListResourceBundle getCurrencyNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.CurrencyNames", locale);
    }

    public static OpenListResourceBundle getLocaleNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.LocaleNames", locale);
    }

    public static OpenListResourceBundle getTimeZoneNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.TimeZoneNames", locale);
    }

    public static ResourceBundle getCollationData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.CollationData", locale);
    }

    public static ResourceBundle getDateFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    public static ResourceBundle getNumberFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    private static ResourceBundle getBundle(final String string, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                return Bundles.of(string, locale, LocaleDataStrategy.INSTANCE);
            }
        });
    }

    private static boolean isNonEuroLangSupported() {
        String string = File.separator;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("java.home")) + string + "lib" + string + "ext" + string + localeDataJarName;
        final File file = new File(string2);
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
        return bl;
    }

    private static Locale[] createLocaleList() {
        String string = LocaleDataMetaInfo.getSupportedLocaleString("sun.text.resources.FormatData");
        if (string.length() == 0) {
            return null;
        }
        int n = string.indexOf("|");
        StringTokenizer stringTokenizer = null;
        stringTokenizer = LocaleData.isNonEuroLangSupported() ? new StringTokenizer(string.substring(0, n) + string.substring(n + 1)) : new StringTokenizer(string.substring(0, n));
        Locale[] localeArray = new Locale[stringTokenizer.countTokens()];
        for (int i = 0; i < localeArray.length; ++i) {
            String string2 = stringTokenizer.nextToken().replace('_', '-');
            if (string2.equals("ja-JP-JP")) {
                string2 = "ja-JP-u-ca-japanese-x-lvariant-JP";
            } else if (string2.equals("th-TH-TH")) {
                string2 = "th-TH-u-nu-thai-x-lvariant-TH";
            } else if (string2.equals("no-NO-NY")) {
                string2 = "no-NO-x-lvariant-NY";
            }
            localeArray[i] = Locale.forLanguageTag(string2);
        }
        return localeArray;
    }

    static /* synthetic */ Locale[] access$000() {
        return LocaleData.createLocaleList();
    }

    private static class AvailableLocales {
        static final Locale[] localeList = LocaleData.access$000();

        private AvailableLocales() {
        }
    }
}

