/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.support;

import com.alibaba.common.lang.StringUtil;
import com.alipay.config.Config;
import com.alipay.support.RSAWindow;
import com.alipay.support.util.GenerateRsaUtil;
import com.alipay.support.util.RSA;
import com.alipay.support.util.RsaKey;
import com.alipay.support.util.SupportUtil;
import com.swt.util.listener.KeyListenerUtil;
import com.test.common.crypto.SignUtilsImpl;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RSASignComposite
extends Composite {
    private static String charset = Charset.defaultCharset().displayName();
    private static String rsaAlgorithm = Config.RSA_SHA256;
    private Text text_input;
    private Text text_output;
    private Text text_privatekey;
    private Text text_sign;
    private String waitCheckSignStr;
    private String inputParamDemo = "\u8bf7\u6c42\u53c2\u6570\u6837\u4f8b\uff1atimestamp=2013-01-01 08:08:08&method=alipay.user.info.auth&app_id=2183&sign_type=RSA&sign=ERITJKEIJKJ&version=1.0&biz_content={\"scopes\":[\"auth_base\"],\"state\":\"init\"}";
    private String inputPrivateKeyDemo = "\u8bf7\u8f93\u5165\u5546\u6237\u5e94\u7528\u79c1\u94a5\uff0c\u6b64\u79c1\u94a5\u662f\u5546\u6237\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u8fdb\u884c\u4ea4\u6613\u7684\u552f\u4e00\u51ed\u8bc1\uff0c\u8bf7\u8c28\u614e\u4fdd\u7ba1\uff01";
    private Button button_6;

    public static void main(String[] args) {
        RSAWindow.main(args);
    }

    public RSASignComposite(Composite parent, int style) {
        super(parent, style);
        Link link_url = new Link((Composite)this, 0);
        link_url.setText("<A>\u4f7f\u7528\u8bf4\u660e</A>");
        link_url.setToolTipText("\u70b9\u51fb\u67e5\u770b\u7b7e\u540d\u8bf4\u660e");
        Display display = parent.getDisplay();
        link_url.setFont(new Font((Device)display, "\u5b8b\u4f53", 10, 0));
        link_url.setBounds(700, 3, 80, 20);
        link_url.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RsaKey.openBrowserForUrl("https://doc.open.alipay.com/docs/doc.htm?docType=1&articleId=106118");
            }
        });
        Label label = new Label((Composite)this, 0);
        label.setBounds(5, 50, 70, 20);
        label.setText("\u8bf7\u6c42\u53c2\u6570\uff1a");
        this.text_input = new Text((Composite)this, 2626);
        this.text_input.setBounds(100, 25, 670, 100);
        this.text_input.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_input));
        this.text_input.setForeground(this.getDisplay().getSystemColor(15));
        this.text_input.setText(this.inputParamDemo);
        this.text_input.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                if (RSASignComposite.this.inputParamDemo.equals(RSASignComposite.this.text_input.getText())) {
                    RSASignComposite.this.text_input.setText("");
                    RSASignComposite.this.text_input.setForeground(RSASignComposite.this.getDisplay().getSystemColor(2));
                }
            }
        });
        this.text_input.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                if (StringUtils.isEmpty((String)RSASignComposite.this.text_input.getText())) {
                    RSASignComposite.this.text_input.setText(RSASignComposite.this.inputParamDemo);
                    RSASignComposite.this.text_input.setForeground(RSASignComposite.this.getDisplay().getSystemColor(15));
                }
            }
        });
        Label label_3 = new Label((Composite)this, 0);
        label_3.setBounds(5, 150, 90, 45);
        label_3.setText("\u5546\u6237\r\n\u5e94\u7528\u79c1\u94a5\uff1a");
        this.text_privatekey = new Text((Composite)this, 2626);
        this.text_privatekey.setBounds(100, 135, 670, 80);
        this.text_privatekey.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_privatekey));
        this.text_privatekey.setForeground(this.getDisplay().getSystemColor(15));
        this.text_privatekey.setText(this.inputPrivateKeyDemo);
        this.text_privatekey.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                if (RSASignComposite.this.inputPrivateKeyDemo.equals(RSASignComposite.this.text_privatekey.getText())) {
                    RSASignComposite.this.text_privatekey.setText("");
                    RSASignComposite.this.text_privatekey.setForeground(RSASignComposite.this.getDisplay().getSystemColor(2));
                }
            }
        });
        this.text_privatekey.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                if (StringUtils.isEmpty((String)RSASignComposite.this.text_privatekey.getText())) {
                    RSASignComposite.this.text_privatekey.setText(RSASignComposite.this.inputPrivateKeyDemo);
                    RSASignComposite.this.text_privatekey.setForeground(RSASignComposite.this.getDisplay().getSystemColor(15));
                }
            }
        });
        Label lblcharset = new Label((Composite)this, 0);
        lblcharset.setBounds(5, 228, 80, 20);
        lblcharset.setText("\u5b57\u7b26\u96c6\uff1a");
        Group chasetGroup = new Group((Composite)this, 32);
        chasetGroup.setBounds(100, 215, 670, 40);
        final Button btnUtf8 = new Button((Composite)chasetGroup, 16);
        btnUtf8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUtf8.getSelection()) {
                    charset = "UTF-8";
                }
            }
        });
        btnUtf8.setText("UTF-8");
        btnUtf8.setBounds(5, 15, 84, 20);
        final Button btnGbk = new Button((Composite)chasetGroup, 16);
        btnGbk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnGbk.getSelection()) {
                    charset = "GBK";
                }
            }
        });
        btnGbk.setText("GBK");
        btnGbk.setBounds(120, 15, 84, 20);
        if (charset.equalsIgnoreCase("UTF-8")) {
            btnUtf8.setSelection(true);
        } else {
            btnGbk.setSelection(true);
        }
        Label lblalgorithm = new Label((Composite)this, 0);
        lblalgorithm.setBounds(5, 265, 80, 20);
        lblalgorithm.setText("\u7b7e\u540d\u65b9\u5f0f\uff1a");
        Group algorithmGroup = new Group((Composite)this, 32);
        algorithmGroup.setBounds(100, 253, 670, 40);
        final Button rsa = new Button((Composite)algorithmGroup, 16);
        rsa.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (rsa.getSelection()) {
                    rsaAlgorithm = Config.RSA_SHA1;
                }
            }
        });
        rsa.setText(Config.SIGN_TYPE_RSA);
        rsa.setBounds(120, 15, 84, 20);
        final Button rsa2 = new Button((Composite)algorithmGroup, 16);
        rsa2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (rsa2.getSelection()) {
                    rsaAlgorithm = Config.RSA_SHA256;
                }
            }
        });
        rsa2.setText(Config.SIGN_TYPE_RSA2);
        rsa2.setBounds(5, 15, 84, 20);
        if (rsaAlgorithm.equalsIgnoreCase(Config.RSA_SHA256)) {
            rsa2.setSelection(true);
        } else {
            rsa.setSelection(true);
        }
        Button button_5 = new Button((Composite)this, 0);
        button_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SignUtilsImpl signUtils = new SignUtilsImpl();
                String pri_key = RSASignComposite.this.text_privatekey.getText().trim();
                if (StringUtils.isNotBlank((String)pri_key)) {
                    if (pri_key.contains("\r\n") || pri_key.contains("\n")) {
                        MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u8b66\u544a", (String)"\u5546\u6237\u5e94\u7528\u79c1\u94a5\u4e0d\u80fd\u5b58\u5728\u6362\u884c\uff0c\u8bf7\u5220\u9664\u6362\u884c\u540e\u518d\u8bd5\uff01");
                        return;
                    }
                } else {
                    MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u8b66\u544a", (String)"\u8bf7\u8f93\u5165\u5546\u6237\u5e94\u7528\u79c1\u94a5\uff01");
                    return;
                }
                if (RsaKey.check_rsa_type(pri_key) == 1 || RsaKey.check_rsa_type(pri_key) == 4) {
                    try {
                        String keyLength = RsaKey.getKeyLength(pri_key);
                        pri_key = RsaKey.convert2pcks8(pri_key, keyLength);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u8b66\u544a", (String)"\u79c1\u94a5\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u79c1\u94a5\uff01");
                        return;
                    }
                } else if (RsaKey.check_rsa_type(pri_key) != 2 && RsaKey.check_rsa_type(pri_key) != 5) {
                    MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u8b66\u544a", (String)"\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u79c1\u94a5\uff01");
                    return;
                }
                String waitSignContent = "";
                try {
                    String inputParam = RSASignComposite.this.text_input.getText();
                    if (RSASignComposite.this.inputParamDemo.equals(inputParam)) {
                        MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u9519\u8bef", (String)"\u8bf7\u8f93\u5165\u8bf7\u6c42\u53c2\u6570\uff01");
                        return;
                    }
                    String signType = GenerateRsaUtil.getUrlParams(inputParam, "sign_type");
                    if (StringUtils.isBlank((String)signType)) {
                        MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u9519\u8bef", (String)"\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570,sign_type\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        return;
                    }
                    if (rsa2.getSelection()) {
                        if (!Config.SIGN_TYPE_RSA2.equals(signType)) {
                            MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u9519\u8bef", (String)"\u7b7e\u540d\u65b9\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\u4e2dsign_type\u662f\u5426\u4e0e\u6240\u9009\u7b7e\u540d\u65b9\u5f0f\u76f8\u540c\uff01");
                            return;
                        }
                    } else if (rsa.getSelection() && !Config.SIGN_TYPE_RSA.equals(signType)) {
                        MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u9519\u8bef", (String)"\u7b7e\u540d\u65b9\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\u4e2dsign_type\u662f\u5426\u4e0e\u6240\u9009\u7b7e\u540d\u65b9\u5f0f\u76f8\u540c\uff01");
                        return;
                    }
                    waitSignContent = RSASignComposite.this.getInputString(inputParam);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u8b66\u544a", (String)"\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff01");
                    return;
                }
                String sign = "";
                try {
                    sign = RSA.sign(waitSignContent, pri_key, rsaAlgorithm, charset);
                }
                catch (Exception ex) {
                    MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u8b66\u544a", (String)"\u7b7e\u540d\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u79c1\u94a5\uff01");
                }
                RSASignComposite.this.text_sign.setText(sign);
                RSASignComposite.this.text_output.setText(RSASignComposite.this.waitCheckSignStr);
                RSASignComposite.this.button_6.setEnabled(true);
                try {
                    RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u4e09\u3001\u751f\u6210\u7b7e\u540d\uff1a\r\n");
                    RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u3010" + sign + "\u3011\r\n");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        button_5.setToolTipText("RSA\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        button_5.setText("\u5f00\u59cb\u7b7e\u540d");
        button_5.setBounds(100, 300, 100, 35);
        this.button_6 = new Button((Composite)this, 0);
        this.button_6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RsaKey.openTxtFile("\u7b7e\u540d\u6b65\u9aa4");
                }
                catch (Exception ex) {
                    MessageDialog.openWarning((Shell)RSASignComposite.this.getShell(), (String)"\u9519\u8bef", (String)"\u6b65\u9aa4\u6587\u4ef6\u6253\u5f00\u5931\u8d25\uff01");
                }
            }
        });
        this.button_6.setToolTipText("RSA\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        this.button_6.setText("\u67e5\u770b\u7b7e\u540d\u751f\u6210\u6b65\u9aa4");
        this.button_6.setBounds(220, 300, 160, 35);
        this.button_6.setEnabled(false);
        Label label_line = new Label((Composite)this, 258);
        label_line.setBounds(10, 340, 770, 5);
        label_line.setText("output__sep");
        Label label_1 = new Label((Composite)this, 0);
        label_1.setBounds(5, 350, 90, 100);
        label_1.setText("\u5f85\u7b7e\u540d\u5185\u5bb9\uff1a");
        this.text_output = new Text((Composite)this, 2626);
        this.text_output.setBounds(100, 350, 670, 100);
        this.text_output.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_output));
        Label label_5 = new Label((Composite)this, 0);
        label_5.setBounds(5, 465, 90, 100);
        label_5.setText("\u7b7e\u540d(sign)\uff1a");
        this.text_sign = new Text((Composite)this, 2626);
        this.text_sign.setBounds(100, 465, 670, 100);
        this.text_sign.addKeyListener(KeyListenerUtil.mkCtrlAKeyListener(this.text_sign));
        Label label_info = new Label((Composite)this, 0);
        label_info.setBounds(30, 575, 720, 50);
        label_info.setText("\u5c06\u751f\u6210\u7684\u201c\u7b7e\u540d\u201d\u8d4b\u503c\u7ed9sign\u53c2\u6570\uff0c\u5c06sign\u653e\u5230\u8bf7\u6c42\u53c2\u6570\u4e2d\uff0c\u518d\u5c06\u6bcf\u4e2a\u53c2\u6570\u503c\u505aurlencode\u540e\u53d1\u8d77\u8bf7\u6c42\u5373\u53ef\u3002");
    }

    protected void checkSubclass() {
    }

    public String getInputString(String inputParam) throws IOException {
        RsaKey.deleteTxtFile("\u7b7e\u540d\u6b65\u9aa4");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u4e00\u3001\u7b7e\u540d\u51c6\u5907\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "1.\u539f\u59cb\u5185\u5bb9\uff1a\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u3010" + inputParam + "\u3011\r\n\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "2.\u7b7e\u540d\u79c1\u94a5\uff1a\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u3010" + this.text_privatekey.getText() + "\u3011\r\n\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u4e8c\u3001\u751f\u6210\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\uff1a\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "1.\u5254\u9664\u53c2\u6570\u540d(\u548c\u53c2\u6570\u503c)\u524d\u540e\u7684\u7a7a\u683c\uff1a\r\n(\u6b63\u5e38\u4e1a\u52a1\u4e0b\uff0c\u53c2\u6570\u503c\u524d\u540e\u4e0d\u5e94\u542b\u6709\u7a7a\u683c)\r\n");
        if (StringUtils.isEmpty((String)inputParam)) {
            return null;
        }
        inputParam = inputParam.trim();
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u3010" + inputParam + "\u3011\r\n\r\n");
        Integer step = 1;
        step = step + 1;
        String removeGatewayUrl = GenerateRsaUtil.removeUrlHead("\u7b7e\u540d\u6b65\u9aa4", inputParam, step);
        step = inputParam.equals(removeGatewayUrl) ? Integer.valueOf(2) : Integer.valueOf(3);
        inputParam = removeGatewayUrl;
        inputParam = GenerateRsaUtil.removeUrlEmptyParams(inputParam, "\u7b7e\u540d\u6b65\u9aa4");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", step + ".\u5254\u9664\u7a7a\u503c\u53c2\u6570\uff1a\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u3010" + inputParam + "\u3011\r\n\r\n");
        step = step + 1;
        if (StringUtil.isNotEmpty((String)inputParam) && inputParam.contains("sign=")) {
            inputParam = GenerateRsaUtil.removeUrlParams(inputParam, new String[]{"sign"});
        }
        inputParam = SupportUtil.sortParams(inputParam);
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", step + ".\u6392\u5e8f\uff1a\r\n");
        RsaKey.appendTxtFile("\u7b7e\u540d\u6b65\u9aa4", "\u3010" + inputParam + "\u3011\r\n\r\n");
        this.waitCheckSignStr = inputParam;
        step = step + 1;
        return inputParam;
    }
}

